<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
<#if sys.getAllPSWorkflows()?? && srflist(sys.getAllPSWorkflows())?size gt 0>
package ${pub.getPKGCodeName()}.job;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;

import java.util.List;
import java.util.ArrayList;

import ${pub.getPKGCodeName()}.util.config.SysInfoProperties;
import ${pub.getPKGCodeName()}.util.feign.FeignRequestInterceptor;
import ${pub.getPKGCodeName()}.util.config.UniWFClientProperties;
import ${pub.getPKGCodeName()}.util.feign.UniWFFeignClient;
import ${pub.getPKGCodeName()}.util.domain.*;

/**
 *
 */
@Component
public class WFJob implements ApplicationRunner {

    UniWFFeignClient uniWFFeignClient;

    @Autowired
    SysInfoProperties sysInfoProperties;

    @Autowired
    public WFJob(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor, UniWFClientProperties uniWFClientProperties) {
        if (uniWFClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class,"http://" + uniWFClientProperties.getServiceId() + "/") ;
		} else if (uniWFClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class, "http://" + uniWFClientProperties.getServiceUrl() + "/") ;
		}
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        // 注册统一工作流（域注册）
        registDomain();

        // 注册工作流引擎
        registWFEngine();

        // 注册业务系统（部署系统）
        registSystem();

        // 注册工作流角色
        registWFRole();

        // 注册业务工作流
        registPSWorkflow();

        // 注册业务实体
        registPSDE();

        // 注册业务实体工作流
        registPSDEWF();

        // 注册业务工作流模式
        registWFMode();
    }

    /**
     * 注册统一工作流（域注册）
     */
    private void registDomain() {
        Workflow workflow = new Workflow();
        workflow.setWorkflowid(sysInfoProperties.getDomainid());
        workflow.setWorkflowname(sysInfoProperties.getDomainname());
        workflow.setLogicname(sysInfoProperties.getDomainlogicname());
        uniWFFeignClient.registDomain(workflow);
    }

    /**
     * 注册工作流引擎
     */
    private void registWFEngine() {
        List<WFEngine> wfengines = new ArrayList<WFEngine>();
        WFEngine wfengine1 = new WFEngine();
        wfengine1.setWfengineid("ACTIVITI");
        wfengine1.setWfenginename("ACTIVITI");
        wfengine1.setWfenginetype("ACTIVITI");
        wfengine1.setLogicname("ACTIVITI");
        wfengine1.setWorkflowid(sysInfoProperties.getDomainid());
        wfengines.add(wfengine1);
        uniWFFeignClient.registWFEngine(wfengines);
    }

    /**
     * 注册业务系统（部署系统）
     */
    private void registSystem() {
        PSSystem pssystem = new PSSystem();
        pssystem.setPssystemid(sysInfoProperties.getSystemid());
        pssystem.setPssystemname(sysInfoProperties.getSystemname());
        pssystem.setWorkflowid(sysInfoProperties.getDomainid());
        pssystem.setServiceid(sysInfoProperties.getServiceid());
        pssystem.setServiceurl(sysInfoProperties.getServiceurl());
        pssystem.setLogicname(sysInfoProperties.getSystemlogicname());
        pssystem.setOrgid(sysInfoProperties.getSysorgid());
        pssystem.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pssystem.setRootpath(sysInfoProperties.getWfrootpath());
        uniWFFeignClient.registPSSystem(pssystem);
    }

    /**
     * 注册工作流角色
     */
    private void registWFRole() {
        List<PSWFRole> pswfroles = new ArrayList<PSWFRole>();
    <#assign i = 0>
    <#if sys.getAllPSWFRoles()??>
        <#list sys.getAllPSWFRoles() as wfrole>
        PSWFRole pswfrole${i} = new PSWFRole();
        pswfrole${i}.setPswfroleid("${wfrole.getDeployId()}");
        pswfrole${i}.setPswfrolename("${wfrole.getName()}");
        pswfrole${i}.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole${i}.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole${i}.setWfroletype("${wfrole.getWFRoleType()}");
        pswfroles.add(pswfrole${i});
            <#assign i++>
        </#list>
    </#if>
        uniWFFeignClient.registPSWFRole(pswfroles);
    }

    /**
     * 注册业务工作流
     */
    private void registPSWorkflow() {
        List<PSWorkflow> psworkflows = new ArrayList<PSWorkflow>();
    <#assign i = 0>
    <#list sys.getAllPSWorkflows() as pswf >
        PSWorkflow psworkflow${i} = new PSWorkflow();
        psworkflow${i}.setPsworkflowid("${pswf.getDeployId()}");
        psworkflow${i}.setPsworkflowname("${pswf.getName()}");
        psworkflow${i}.setLogicname("${pswf.getLogicName()}");
        psworkflow${i}.setWorkflowid(sysInfoProperties.getDomainid());
        psworkflow${i}.setPssystemid(sysInfoProperties.getSystemid());
        psworkflow${i}.setWfenginetype("ACTIVITI");
        psworkflow${i}.setOrgid(sysInfoProperties.getSysorgid());
        psworkflow${i}.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        psworkflow${i}.setWftype("${pswf.getWFType()!ORG}");
        psworkflows.add(psworkflow${i});
        <#assign i++>
    </#list>
        uniWFFeignClient.registPSWorkflow(psworkflows);
    }

    /**
     * 注册业务实体
     */
    private void registPSDE() {
        List<PSDataEntity> psdataentities = new ArrayList<PSDataEntity>();
    <#assign i = 0>
    <#if sys.getAllPSDataEntities()??>
        <#list sys.getAllPSDataEntities() as psde >
            <#if psde.hasPSDEWF()>
        PSDataEntity psdataentity${i} = new PSDataEntity();
        psdataentity${i}.setPsdataentityid("${psde.getDeployId()}");
        psdataentity${i}.setPsdataentityname("${psde.getName()}");
        psdataentity${i}.setLogicname("${psde.getLogicName()}");
        psdataentity${i}.setCodename("${psde.getCodeName()}");
        psdataentity${i}.setWorkflowid(sysInfoProperties.getDomainid());
        psdataentity${i}.setPssystemid(sysInfoProperties.getSystemid());
        psdataentities.add(psdataentity${i});
            <#assign i++>
            </#if>
        </#list>
    </#if>
        uniWFFeignClient.registPSDataEntity(psdataentities);
    }

    /**
     * 注册业务实体工作流
     */
    private void registPSDEWF() {
        List<PSDEWF> psdewfs = new ArrayList<PSDEWF>();
    <#assign i = 0>
    <#list sys.getAllPSWorkflows() as pswf >
        <#if pswf.getPSWFDEs()??>
            <#assign deArr = [] />
            <#list pswf.getPSWFDEs() as pswfde>
                <#if !deArr?seq_contains(pswfde.getDeployId())>
        PSDEWF psdewf${i} = new PSDEWF();
        psdewf${i}.setPsdewfid("${pswfde.getDeployId()}");
        psdewf${i}.setPsdewfname("${pswfde.getName()}");
        psdewf${i}.setLogicname("${pswfde.getPSDataEntity().getLogicName()}");
        psdewf${i}.setWfproxymode(${pswfde.getWFProxyMode()});
        psdewf${i}.setPsdataentityid("${pswfde.getPSDataEntity().getDeployId()}");
        psdewf${i}.setPsdecodename("${pswfde.getPSDataEntity().getCodeName()}");
        psdewf${i}.setPsworkflowid("${pswf.getDeployId()}");
        psdewf${i}.setWorkflowid(sysInfoProperties.getDomainid());
        psdewf${i}.setPssystemid(sysInfoProperties.getSystemid());
        <#if pswfde.getUDStatePSDEField()??>
        psdewf${i}.setUdstatefield("${pswfde.getUDStatePSDEField().getCodeName()?lower_case}");
        </#if>
        <#if pswfde.getWFStatePSDEField()??>
        psdewf${i}.setWfstatefield("${pswfde.getWFStatePSDEField().getCodeName()?lower_case}");
        </#if>
        <#if pswfde.getWFStepPSDEField()??>
        psdewf${i}.setWfstepfield("${pswfde.getWFStepPSDEField().getCodeName()?lower_case}");
        </#if>
        <#if pswfde.getErrorPSDEMainState()??>
        psdewf${i}.setErrorvalue("${pswfde.getErrorPSDEMainState().getStateValue()}");
        </#if>
        <#if pswfde.getFinishPSDEMainState()??>
        psdewf${i}.setFinishvalue("${pswfde.getFinishPSDEMainState().getStateValue()}");
        </#if>
        <#if pswfde.getProcessPSDEMainState()??>
        psdewf${i}.setProcessvalue("${pswfde.getProcessPSDEMainState().getStateValue()}");
        </#if>

        psdewfs.add(psdewf${i});
                    <#assign deArr = deArr + [pswfde.getDeployId()] >
                    <#assign i++>
                </#if>
            </#list>
        </#if>
    </#list>
        uniWFFeignClient.registPSDEWF(psdewfs);
    }

    /**
     * 注册业务工作流模式
     */
    private void registWFMode() {
<#--        List<WFMode> wfmodes = new ArrayList<WFMode>();-->
<#--        模型还没找到-->
<#--    <#assign i = 0>-->
<#--    <#if sys.getAllPSDataEntities()??>-->
<#--        <#list sys.getAllPSWFMode() as pswf >-->
<#--        WFMode wfmode${i} = new WFMode();-->
<#--        wfmode${i}.setPSWorkflowid("${pswf.getDeployId()}");-->
<#--        wfmode${i}.setPSWorkflowname("${pswf.getCodeName()}");-->
<#--        wfmode${i}.setLogicname("${pswf.getLogicName()}");-->
<#--        wfmodes.add(wfmode${i});-->
<#--        <#assign i++>-->
<#--        </#list>-->
<#--    </#if>-->
<#--        uniWFFeignClient.registWFMode(wfmodes);-->
    }
}
</#if>
